<%-- Copyright (c) Oracle Corporation 2002. All Rights Reserved. --%>

<%--
    NAME
        PhotoAlbumInsertPhoto.jsp

    DESCRIPTION
        PhotoAlbumInsertPhoto.jsp is one component of a JavaServer Pages
        application that demonstrates the use of Oracle Multimedia Java 
        Classes for Servlets and JSPs by implementing a simple photo album 
        application. This page processes the POST request that stores the 
        new photo in the database. This page uses the PhotoAlbumBean JavaBean 
        to access the database.

    NOTES
        See the README.txt file for information on how to build and
        run the demo.
--%>

<%@ page language="java" %>
<%@ page import="imjspdemo.PhotoAlbumBean" %>
<%@ page import="oracle.ord.im.OrdHttpJspResponseHandler" %>
<%@ page import="oracle.ord.im.OrdHttpUploadFormData" %>
<%@ page import="oracle.ord.im.OrdHttpUploadFile" %>

<jsp:useBean id="album" scope="page" class="imjspdemo.PhotoAlbumBean"/>
<jsp:useBean id="handler" scope="page"
             class="oracle.ord.im.OrdHttpJspResponseHandler"/>
<jsp:useBean id="formData" scope="page"
             class="oracle.ord.im.OrdHttpUploadFormData"/>

<%
    //
    // Use a try block to ensure the JDBC connection is released and to
    // release any temporary files that might be used to hold uploaded
    // images. Note that, by default, this sample holds uploaded photos
    // in memory temporarily, not in temporary files. To use temporary
    // files, add a call to setMaxMemory before calling parseFormData.
    //
    String description = null;
    String location = null;
    OrdHttpUploadFile uploadPhoto = null;
    try
    {
        //
        // Initialize the parser.
        //
        formData.setServletRequest( request );

        //
        // Forward to upload form if not an upload request.
        //
        if ( !formData.isUploadRequest() )
        {
%>
            <jsp:forward page="PhotoAlbumUploadForm.jsp"/>
<%
            return;
        }

        //
        // Get the form field values.
        //
        formData.parseFormData();
        description = formData.getParameter( "description" );
        location = formData.getParameter( "location" );
        uploadPhoto = formData.getFileParameter( "photo" );

        //
        // An image file is required.
        //
        if ( uploadPhoto == null ||
             uploadPhoto.getOriginalFileName() == null ||
             uploadPhoto.getOriginalFileName().length() == 0
           )
        {
%>
            <jsp:forward page="PhotoAlbumUploadForm.jsp?error=Please+provide+a+file+name."/>
<%
            return;
        }

        if( uploadPhoto.getContentLength() == 0 )
        {
%>
            <jsp:forward page="PhotoAlbumUploadForm.jsp?error=Please+provide+a+valid+image+file."/>
<%
            return;
        }


        //
        // Use file name as description if not supplied.
        //
        if ( description == null || description.length() == 0 )
        {
            description = "Image from file: " +
                           uploadPhoto.getSimpleFileName() + ".";
            if(description.length() > 40)
            {
                description = description.substring(0, 40);
            }
        }

        //
        // Insert the new entry and display the updated album when done
        //
        album.setDescription( description );
        album.setLocation( location );
        album.insertNewPhoto( uploadPhoto );
    }
    finally
    {
        //
        // Ensure the JDBC connection is released and any temporary files
        // are deleted.
        //
        album.release();
        formData.release();
    }

%>

<%-- HTML header --%>
<html lang="EN">
<head>
<title>Oracle Multimedia JavaServer Pages Photo Album Demo</title>
</head>

<%-- Direct browser to main page --%>
<meta http-equiv="refresh" content="2;url=PhotoAlbum.jsp">

<body>

<%-- Page heading --%>
<table border="0" width="100%">
  <tr>
    <td colspan="2" bgcolor="#f7f7e7" align="center"><font size="+2">
      Oracle Multimedia JavaServer Pages Photo Album Demo</font>
    </td>
  </tr>
</table>

<%-- Display header and instructions --%>
<p>
<font size=3 color="#336699">
<b>Photo successfully uploaded into photo album</b>
</font>
<hr size=1>
</p>
<p>
Please click on the link below or wait for the browser to refresh the page.
</p>

<%-- Output link to return to the main page --%>
<p>
<table width="100%">
  <tr bgcolor="#f7f7e7">
    <td colspan="3" align="center">
      <a href="PhotoAlbum.jsp">Return to photo album</a>
    </td>
  </tr>
</table>
</p>

<%-- Finish the page --%>
</body>
</html>

